* This program practice the regression tool in the context of the wage premium in finance using NLSY79 data set


# delimit;
clear ;
set more off ;

set matsize 11000 ;

capture log close ;


/*
GLOBALS
INSERET THE LOCATION/FOLDER ON YOUR COMPUTER
*/

global FOLDER "/Users/yonarubinstein/Dropbox/TEACHING/LSE/MG4A4 EMPIRICAL RESEARCH STRATEGY FOR MANAGERIAL ECONOMICS/POST/DATA AND PROGRAMS/" ;

cd "$LOG/" ;

log using "$FOLDER/MG4A4 THE REGRESSION TOOL.log", replace ;


/* ********************************************************************************************************* */
/* ******************************************** UPLOAD THE FILE ******************************************** */
/* ********************************************************************************************************* */


use "$DATA/MG4A4_NLSY79_2555.dta", clear ;


/*
(1) DESCRIBE
*/

des 
id year _SEXi _RACEi _SEXi _AFQTi _Sit _EXP1it _EXP2it 
_FINANCEit _TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit ;

/*
(2) SUMMARIZE
*/

sum
id year _SEXi _RACEi _SEXi _AFQTi _Sit _EXP1it _EXP2it 
_FINANCEit _TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit ;


/*
(3) REGRESSIONS
*/

reg _Wit _FINANCEit, robust  ;
estimates store OLS1, title((CRUDE));


reg _Wit _FINANCEit _AFQTi _Sit _EXP1it _EXP2it, robust ;
estimates store OLS2, title((RESID1));


estout OLS1 OLS2 using "$FOLDER/MG4A4 THE REGRESSION TOOL NLSY79.txt", 
replace keep 
(_cons _FINANCEit _AFQTi _Sit _EXP1it _EXP2it)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("Table 434" "REGRESSION TOOL")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;


/*
An Example: Full vs. Partial Relationship 
*/

/*
(4) REGRESSIONS
*/

reg _FINANCEit _AFQTi _Sit _EXP1it _EXP2it, robust ;
predict _FINANCERit, resid ;


reg _Wit _FINANCERit, robust  ;



log close ;
